using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        // Citanje ulaza
        int N = int.Parse(Console.ReadLine());
        List<int>[] graph = new List<int>[N + 1];
        for (int i = 1; i <= N; i++)
        {
            graph[i] = new List<int>();
        }

        for (int i = 1; i < N; i++)
        {
            int[] uv = Console.ReadLine().Split().Select(int.Parse).ToArray();
            int U = uv[0];
            int V = uv[1];
            graph[U].Add(V);
            graph[V].Add(U);
        }

        int[] platforms = Console.ReadLine().Split().Select(int.Parse).ToArray();
        int[] changes = Console.ReadLine().Split().Select(int.Parse).ToArray();

        // Inicijalizacija i pozivanje DFS algoritma
        int[] jumps = new int[N + 1];
        DFS(graph, platforms, changes, jumps, 1, 0);

        // Ispis rezultata
        Console.WriteLine(string.Join(" ", jumps.Skip(1)));
    }

    static void DFS(List<int>[] graph, int[] platforms, int[] changes, int[] jumps, int node, int parent)
    {
        int currentJump = jumps[node];
        foreach (int neighbor in graph[node])
        {
            if (neighbor != parent)
            {
                // Ažuriranje broja skokova ako postoji promena u trenutnoj sobi
                int jumpChange = changes[node] == 1 ? 1 : 0;

                // Ažuriranje broja skokova za susednu sobu
                jumps[neighbor] = currentJump + 1 - jumpChange;

                // Rekurzivni poziv za susednu sobu
                DFS(graph, platforms, changes, jumps, neighbor, node);
            }
        }
    }
}